% mxRUN(1)
% MCXTRACE xray Ray Tracing Team
% Jan. 07, 2026

# NAME

**mxrun** - Running McXtrace simulations from the command-line

# SYNOPSIS

**mxrun** [-cpnN] *INSTR* [-sndftgahi] params={val|min,max|min,guess,max}... [-hB][-c CMD][-f FROM][-n NAME][-o DIR][-s SCRIPT]

# DESCRIPTION

The **mxrun** front-end provides a convenient command-line interface for running
simulations with the same automatic compilation features. It also provides a
facility for running a series of simulations while varying an input
parameter, as well as a multiparameter non-linear optimisation. The command
`mxrun sim args ...` will compile the instrument definition INSTR e.g.
`sim.instr` (if necessary) into an executable simulation `sim.out`. It will
then run `sim.out`, passing the argument list `args` usually given as a
series of `param=value` pairs. The `-h` option will list valid options.

# OPTIONS

**--version**
:   show program's version number and exit

**-h, --help**
:   show this help message and exit

**-c, --force-compile**
:   force rebuilding of instrument. This may be needed in case any
    component definitions are changed (in which case mxrun does not automatically
    recompile), or if a new version of McXtrace has been installed.

**-I I**
:   Append path *I* to McCode search path (implies -c)

**--D1=D1**
:   Set extra -D args (implies -c)

**--D2=D2**
:   Set extra -D args (implies -c)

**--D3=D3**
:   Set extra -D args (implies -c)

**-p FILE, --param=FILE**
:   Read parameters from file FILE
    The file should consist of specifications of the form name =value separated
    by spaces or line breaks. Multiple -p options may be given together with 
    direct parameter specifications on the command line. If a parameter is 
    assigned multiple times, later assignments override previous ones.

**-N NP, --numpoints=NP**
:   Set number of scan points, varying one or more parameters within specified 
    intervals. Such a series of simulations is called a scan. To specify an interval 
    for a parameter X, it should be assigned two values separated by a comma. 
    For example, the command *mxrun sim.instr -N4 X=2,8 Y=1* would run the 
    simulation defined in sim.instr four times, with X having the values 2, 4, 6, 
    and 8, respectively. After running the simulation, the results will be written 
    to the file mxcode.dat by default. This file contains one line for each 
    simulation run giving the values of the scanned input variables along with 
    the integrated intensity and estimated error in all monitors

**-L, --list**
:   Use a fixed list of points for linear scanning

**-M, --multi**
:   Run a multi-dimensional scan

**--autoplot**
:   Open plotter on generated dataset

**--autoplotter=AUTOPLOTTER**
:   Specify the plotter used with --autoplot

**--embed**
:   Store copy of instrument file in output directory

**--mpi=NB_CPU**
:   Spread simulation over NB_CPU machines using MPI

**--openacc**
:   parallelize using openacc

**--funnel**
:   funneling simulation flow, e.g. for mixed CPU/GPU

**--machines=machines**
:   Defines path of MPI machinefile to use in parallel mode

**--optimise-file=FILE**
:   Store scan results in FILE (defaults to: "mxcode.dat")

**--no-cflags**
:   Disable optimising compiler flags for faster compilation

**--no-main**
:   Do not generate a main(), e.g. for  use  with  mcxtrace2vitess.pl.
    Implies -c

**--verbose**
:   Enable verbose output

**--write-user-config**
:   Generate a user config file

**--override-config=PATH**
:   Load config file from specific dir

**--optimize**
:   Optimize instrument variable parameters to maximize monitors

**--optimize-maxiter=optimize_maxiter**
:   Maximum number of optimization iterations to perform

**--optimize-tol=optimize_tol**
:   Tolerance  for  optimization  termination.  When  optimizetol is
    specified, the selected optimization algorithm sets  some  rele‐
    vant solver-specific tolerance(s) equal to optimize-tol

**--optimize-method=optimize_method**
:   Optimization  solver  in `['powell', 'nelder-mead', 'cg', 'bfgs',
    'newton-cg', 'l-bfgs-b', 'tnc', 'cobyla',  'slsqp',  'trust-con‐
    str', 'dogleg', 'trust-ncg', 'trust-exact', 'trust-krylov']` (de‐
    fault: `powell`) You can use your custom  method  `method(fun,  x0,
    args,  **kwargs, **options)`. Please refer to scipy documentation
    for proper use of it:  *https://docs.scipy  .org/doc/scipy/refer‐
    ence/generated/scipy.optimize.mini mize.html?highlight=minimize*

**--optimize-minimize**
:   Choose to minimize the monitors instead of maximize

**--optimize-monitor=optimize_monitor**
:   Name of a single monitor to optimize (default is to use all)

**--showcfg=ITEM**
:   Print  selected  cfg item and exit (paths are resolved and abso‐
    lute). Allowed values are "bindir", "libdir", "resourcedir", and
    "tooldir".

## INSTRUMENT OPTIONS

**-s SEED, --seed=SEED**
:   Set random seed (must be: SEED != 0)

**-n COUNT, --ncount=COUNT**
:   Set number of xrays to simulate

**-t trace, --trace=trace**
:   Enable trace of xrays through instrument

**--no-trace**
:   Disable trace of xrays in instrument (implies -c!)

**-d DIR, --dir=DIR**
:   Put all data files in directory DIR. Additionally, the directory will have
    subdirectories 1, 2, 3,. . . containing all data files output from the 
    different simulations.

**--format=FORMAT**
:   Output  data  files using format FORMAT, usually McCode or NeXus
    (format list obtained from <instr>.out -h)

**--bufsiz=BUFSIZ**
:   Monitor_nD list/buffer-size (defaults to 1000000)

**--vecsize=VECSIZE**
:   vector length in OpenACC parallel scenarios

**--numgangs=NUMGANGS**
:   number of 'gangs' in OpenACC parallel scenarios

**--gpu_innerloop=INNERLOOP**
:   Maximum particles in an OpenACC kernel  run.  (If  INNERLOOP  is
    smaller than ncount we repeat)

**--no-output-files**
:   Do not write any data files

**-i, --info**
:   Detailed instrument information

**--list-parameters**
:   Print the instrument parameters to standard out

**--meta-list**
:   Print all metadata defining component names

**--meta-defined=META_DEFINED**
:   Print  metadata  names  for  component,  or  indicate
    if component:name exists.

**--meta-type=META_TYPE**
:   Print metadata type for component:name

**--meta-data=META_DATA**
:   Print metadata for component:name

# FILES

/usr/share/mcxtrace/resources
/usr/share/mcxtrace/tools/Python/mccodelib/mccode_config.json
~/.mcxtrace/mccode_config.json
http://www.mcxtrace.org

# EXAMPLES

Run the *Test_SX* example (Single crystal diffraction)
:   - `mxrun Test_SX.instr -d output_dir -n 1e7 TTH=13.4`

# AUTHORS

McXtrace Team (mcxtrace.org)

# SEE ALSO

mcxtrace(1), mxdoc(1), mxplot(1), mxrun(1), mxgui(1), mxdisplay(1)

